/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.model;

import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.GlobalItem;
import com.ibm.form.api.internal.model.GlobalPage;
import com.ibm.form.api.internal.model.Item;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import javax.naming.OperationNotSupportedException;
import org.xml.sax.Attributes;

public abstract class XMLModel
extends Option {
    public static final int XML_UKNOWN_CHILD = 0;
    public static final int XML_INSTANCES_CHILD = 1;
    static final String XML_INSTANCES_ID = "instances";
    static final String XML_INSTANCE_ID = "instance";

    public static int getChildType(String localName) {
        int childType = XML_INSTANCES_ID.equals(localName) ? 1 : 0;
        return childType;
    }

    public static int getChildTypeAndValidate(String uri, String localName) {
        int childType = XMLModel.getChildType(localName);
        if (0 != childType && !FormNamespaceSupport.isXFDLNamespace(uri)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XformsNamespaceError.toStringAsRequest(), (Object)uri);
            childType = 0;
        }
        return childType;
    }

    public static String isXMLModelInstance(String uri, String localName, Attributes attributes) {
        if (!XML_INSTANCE_ID.equals(localName)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XmlElementError.toStringAsRequest(), (Object)XML_INSTANCE_ID, (Object)localName);
            return null;
        }
        if (!FormNamespaceSupport.isXFormsNamespace(uri, true)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XformsNamespaceError.toStringAsRequest(), (Object)uri);
            return null;
        }
        return FormNode.getAttributeValue(attributes, "id");
    }

    static boolean isXMLModel(Item parent, String uri, String localName) {
        if (!"xmlmodel".equals(localName)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XmlElementError.toStringAsRequest(), (Object)"xmlmodel", (Object)localName);
            return false;
        }
        if (!FormNamespaceSupport.isXFDLNamespace(uri)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XfldNamespaceError.toStringAsRequest(), (Object)uri);
            return false;
        }
        if (!(parent instanceof GlobalItem)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.ReferenceRootInvalid.toStringAsRequest(), (Object)"global.global.xmlmodel");
            return false;
        }
        if (!(parent.parent instanceof GlobalPage)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.ReferenceRootInvalid.toStringAsRequest(), (Object)"global.global.xmlmodel");
            return false;
        }
        return true;
    }

    private XMLModel() throws OperationNotSupportedException {
        super(null, null, null, null, null, 4);
        throw new OperationNotSupportedException();
    }
}

