/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.model;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Page;
import com.ibm.form.api.internal.parser.sax.XFDLParser;
import com.ibm.form.api.internal.utilities.FormLogger;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class XFDL
extends FormNode {
    public static final String XFDL_ID = "XFDL";
    public Map pages = new LinkedHashMap();

    public static String isXFDLElement(String uri, String localName) {
        if (!XFDL_ID.equals(localName)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XmlElementError.toStringAsRequest(), (Object)XFDL_ID, (Object)localName);
            return null;
        }
        if (!FormNamespaceSupport.isXFDLNamespace(uri)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XfldNamespaceError.toStringAsRequest(), (Object)uri);
            return null;
        }
        return XFDL_ID;
    }

    public XFDL(String uri, String qName, Attributes attributes, FormNamespaceSupport namespace, XFDLParser parser) {
        super(1, uri, qName, attributes, namespace, parser);
        this.parseMaps = null == parser ? new HashMap(0) : parser.getParserData().getCacheMap();
    }

    public void add(boolean notify) {
        throw new UnsupportedOperationException();
    }

    public void addChild(FormNode page, boolean notify) {
        String key = page.getURIQualifiedName();
        Page oldPage = (Page)this.pages.put(key, page);
        if (null != oldPage) {
            Logger logger = FormLogger.getLogger();
            if (4 != page.status) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Incorrect new page state " + page.getReference(null));
                }
                throw new IllegalStateException();
            }
            if (16 != oldPage.status) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Page already defined " + oldPage.getReference(null));
                }
                this.pages.put(key, oldPage);
            }
        }
        if (notify) {
            this.setStatus(2);
            this.setParentStatus(2);
        }
    }

    public void dispose() {
        super.dispose();
        if (null != this.pages) {
            FormNode[] children = this.getAllChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].dispose();
                this.pages.remove(children[i].getURIQualifiedName());
            }
            this.pages = null;
        }
    }

    public FormNode[] getAllChildren() {
        Object[] children = this.pages.values().toArray();
        FormNode[] newArray = new Page[children.length];
        System.arraycopy(children, 0, newArray, 0, newArray.length);
        return newArray;
    }

    public String getLocalName() {
        return XFDL_ID;
    }

    public FormNode getStartNode(Action action) {
        return this;
    }

    public boolean shouldParseChild(String childName) {
        String prefix = this.getPrefixFromNamespaceURI(this.getXFDLNamespaceURI());
        String alternateName = "".equals(prefix) ? childName : prefix + ":" + childName;
        return this.shouldParseChild(this.getChild(childName), childName, alternateName, alternateName);
    }

    public void validateReference(Action action) {
        int nameLength = action.getNumberOfRelativeReferenceElements();
        switch (action.getReferenceType()) {
            case 393216: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 == nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.PageReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 131072: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (2 == nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ItemReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 65536: 
            case 589824: {
                if (65536 == action.getReferenceType() ? action.hasArrayIndices() : !action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (3 == nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.OptionReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            default: {
                throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
            }
        }
    }

    FormNode getChild(String uriQName, boolean create, String prefixQName, FormNode namespaceNode) {
        return (Page)this.pages.get(uriQName);
    }

    void removeChild(String uriQName, boolean notify) {
        if (null == this.pages) {
            throw new IllegalStateException();
        }
        this.removeChild((FormNode)this.pages.get(uriQName), notify);
    }
}

