/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.model;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Item;
import com.ibm.form.api.internal.model.XFDL;
import com.ibm.form.api.internal.utilities.FormLogger;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class Page
extends FormNode {
    static final String PAGE_ID = "page";
    private Map items = new LinkedHashMap(0);

    public static String isPage(String uri, String localName, Attributes attributes) {
        if (!PAGE_ID.equals(localName)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XmlElementError.toStringAsRequest(), (Object)PAGE_ID, (Object)localName);
            return null;
        }
        if (!FormNamespaceSupport.isXFDLNamespace(uri)) {
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XfldNamespaceError.toStringAsRequest(), (Object)uri);
            return null;
        }
        String sid = Page.getSidAndValidateNamespace(attributes);
        if ("global".equals(sid)) {
            if (null != sid) {
                FormNode.errorCode = LocalizedStringFormat.bind(Messages.InvalidXmlAttribute.toStringAsRequest(), (Object)"sid", (Object)sid);
            }
            return null;
        }
        return sid;
    }

    static String getSidAndValidateNamespace(Attributes attributes) {
        String attributeURI = null;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            if (!"sid".equals(attributes.getLocalName(i))) continue;
            attributeURI = attributes.getURI(i);
            if ("".equals(attributeURI)) {
                return attributes.getValue(i);
            }
            if (FormNamespaceSupport.isXFDLNamespace(attributeURI)) {
                return attributes.getValue(i);
            }
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XfldNamespaceError.toStringAsRequest(), (Object)attributeURI);
            return null;
        }
        FormNode.errorCode = LocalizedStringFormat.bind(Messages.InvalidXmlAttribute.toStringAsRequest(), (Object)"sid", null);
        return null;
    }

    public Page(XFDL parent, String uri, String qName, String sid, Attributes attributes, FormNamespaceSupport namespace) {
        super(2, parent, uri, qName, attributes, namespace);
        this.qualifiedName = sid;
        this.referenceName = sid;
        this.parseMaps = parent.getParseMaps(sid);
    }

    public void addChild(FormNode item, boolean notify) {
        String key = item.getURIQualifiedName();
        Item oldItem = (Item)this.items.put(key, item);
        if (null != oldItem) {
            Logger logger = FormLogger.getLogger();
            if (4 != item.status) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Incorrect new item state " + item.getReference(null));
                }
                throw new IllegalStateException();
            }
            if (16 != oldItem.status && logger.isLoggable(Level.FINE)) {
                logger.fine("Item already defined " + oldItem.getReference(null));
                this.items.put(key, oldItem);
            }
        }
        if (notify) {
            this.setStatus(2);
            this.setParentStatus(2);
        }
    }

    public void dispose() {
        super.dispose();
        if (null != this.items) {
            FormNode[] children = this.getAllChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].dispose();
                this.items.remove(children[i].getURIQualifiedName());
            }
            this.items = null;
        }
    }

    public FormNode[] getAllChildren() {
        Object[] children = this.items.values().toArray();
        FormNode[] newArray = new Item[children.length];
        System.arraycopy(children, 0, newArray, 0, newArray.length);
        return newArray;
    }

    public FormNode getStartNode(Action action) {
        switch (action.getReferenceType()) {
            case 393216: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements());
            }
            case 131072: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() - 1);
            }
            case 65536: 
            case 589824: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() - 2);
            }
        }
        throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
    }

    public String getReference(FormNode contextNode) {
        return this.referenceName;
    }

    public boolean shouldParseChild(String childName) {
        String prefix = this.getPrefixFromNamespaceURI(this.getXFDLNamespaceURI());
        String alternateName = "".equals(prefix) ? childName : prefix + ":" + childName;
        return this.shouldParseChild(this.getChild(childName), childName, alternateName, alternateName);
    }

    public void validateReference(Action action) {
        int nameLength = action.getNumberOfRelativeReferenceElements();
        switch (action.getReferenceType()) {
            case 393216: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 == nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.PageReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 131072: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 <= nameLength && 2 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ItemReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 65536: 
            case 589824: {
                if (65536 == action.getReferenceType() ? action.hasArrayIndices() : !action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (2 <= nameLength && 3 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ItemReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            default: {
                throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
            }
        }
    }

    FormNode getChild(String uriQName, boolean create, String prefixQName, FormNode namespaceNode) {
        return (Item)this.items.get(uriQName);
    }

    void removeChild(String uriQName, boolean notify) {
        if (null == this.items) {
            throw new IllegalStateException();
        }
        this.removeChild((FormNode)this.items.get(uriQName), notify);
    }
}

