/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.model;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.ArrayOption;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Item;
import com.ibm.form.api.internal.model.XFDL;
import com.ibm.form.api.internal.model.XFormsModels;
import com.ibm.form.api.internal.model.XMLModel;
import com.ibm.form.api.internal.parser.sax.WriteHandler;
import com.ibm.form.api.internal.utilities.FormLogger;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class Option
extends FormNode {
    public static final int REGULAR_OPTION = 1;
    public static final int XMLMODEL_OPTION = 2;
    public static final int XFORMSMODELS_OPTION = 4;
    public static final String ARRAY_OPTION_ID = "ae";
    static final String XMLMODEL_ID = "xmlmodel";
    static final String XFORMSMODELS_ID = "xformsmodels";
    public String value = null;
    public Option optionRoot;
    String identifier;
    List options = new ArrayList(0);
    private boolean valueChanged = false;

    public static int getOptionType(String localName) {
        int optionType = localName.equals(XMLMODEL_ID) ? 2 : (localName.equals(XFORMSMODELS_ID) ? 4 : 1);
        return optionType;
    }

    public static int isOption(Item item, String uri, String localName) {
        if (XMLModel.isXMLModel(item, uri, localName)) {
            return 2;
        }
        if (XFormsModels.isXFormsModels(item, uri, localName)) {
            return 4;
        }
        return 1;
    }

    public Option(FormNode parent, String uri, String qName, Attributes attributes, FormNamespaceSupport namespace) {
        super(4, parent, uri, qName, attributes, namespace);
        this.initialize(parent, uri);
    }

    Option(FormNode parent, String uri, String qName, Attributes attributes, FormNamespaceSupport namespace, int nodeType) {
        super(nodeType, parent, uri, qName, attributes, namespace);
        this.initialize(parent, uri);
    }

    public void add(boolean notify) {
        if (!this.options.isEmpty()) {
            this.value = null;
        }
        this.parent.addChild(this, notify);
    }

    public void addChild(FormNode arrayOption, boolean notify) {
        int index;
        if (0 == this.options.size()) {
            this.value = null;
            this.valueChanged = false;
        }
        if (-1 == (index = this.options.indexOf(arrayOption))) {
            this.options.add(arrayOption);
        } else if (null == arrayOption) {
            this.options.add(arrayOption);
        } else {
            Logger logger = FormLogger.getLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Option already defined " + arrayOption.getReference(null));
            }
        }
        if (notify) {
            this.setStatus(2);
            this.setParentStatus(2);
        }
    }

    public void addChildAt(int index, FormNode arrayOption, boolean notify) {
        if (index >= this.options.size()) {
            throw new IllegalArgumentException();
        }
        this.options.add(index, arrayOption);
        for (int i = index; i < this.options.size(); ++i) {
            ArrayOption child = (ArrayOption)this.options.get(i);
            if (null == child) continue;
            child.setReferenceName((Option)child.parent, child.referenceName, index, false);
        }
        if (notify) {
            this.setStatus(2);
            this.setParentStatus(2);
        }
    }

    public int arrayIndex(String name) {
        int result = -1;
        boolean isChar = false;
        char[] ch = name.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (Character.isDigit(ch[i])) continue;
            isChar = true;
            break;
        }
        if (!isChar) {
            try {
                result = new Integer(name);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        if (null != this.options) {
            FormNode[] children = this.getAllChildren();
            for (int i = 0; i < children.length; ++i) {
                if (null == children[i]) continue;
                children[i].dispose();
                this.options.remove(children[i]);
            }
            this.options = null;
        }
        this.optionRoot = null;
    }

    public String generateXML(int level, String[] indent, Set namespacePrefixes) {
        String outName = this.getPrefixQualifiedName();
        indent = this.expandIndentString(level, indent);
        FormNode[] children = this.getAllChildren();
        if (0 == children.length) {
            String result = this.generateXMLStartElement(indent[level], outName, false, namespacePrefixes);
            if (null != this.value) {
                result = result + WriteHandler.canonicalizeValue(this.value);
            }
            result = result + this.generateXMLEndElement("", outName);
            return result;
        }
        String result = this.generateXMLStartElement(indent[level], outName, false, namespacePrefixes);
        for (int i = 0; i < children.length; ++i) {
            if (null == children[i]) continue;
            result = result + "\n" + children[i].generateXML(level + 1, indent, new HashSet(0));
        }
        result = result + "\n" + this.generateXMLEndElement(indent[level], outName);
        return result;
    }

    public FormNode[] getAllChildren() {
        Object[] children = this.options.toArray();
        FormNode[] newArray = new ArrayOption[children.length];
        System.arraycopy(children, 0, newArray, 0, newArray.length);
        return newArray;
    }

    public String getAttributeDescription() {
        String result = "";
        if (null == this.attributes) {
            return result;
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            String name = this.attributes.getQName(i);
            String value = this.attributes.getValue(i);
            StringBuffer canoniclizedValue = WriteHandler.canonicalizeAttribute(value);
            if (2 == this.status && 0 == this.options.size()) {
                if ("compute".equals(name)) continue;
                result = result + " " + name + "=\"" + canoniclizedValue + "\"";
                continue;
            }
            result = result + " " + name + "=\"" + canoniclizedValue + "\"";
        }
        return result;
    }

    public FormNode getChild(int index) {
        if (index >= this.options.size()) {
            return null;
        }
        return (Option)this.options.get(index);
    }

    public int getChildCount() {
        return this.options.size();
    }

    public int getIndexOf(Option option) {
        return this.options.indexOf(option);
    }

    public String getInstanceIdentifier() {
        return this.identifier;
    }

    public FormNode getStartNode(Action action) {
        switch (action.getReferenceType()) {
            case 393216: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() + 2);
            }
            case 131072: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() + 1);
            }
            case 65536: 
            case 589824: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements());
            }
        }
        throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
    }

    public String getReference(FormNode contextNode) {
        if (this.parent.equals(contextNode)) {
            return this.referenceName;
        }
        return this.parent.getReference(contextNode) + "." + this.referenceName;
    }

    public String getLiteral() {
        return this.value;
    }

    public boolean hasChildren() {
        ListIterator it = this.options.listIterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            if (null == option) {
                return true;
            }
            if (16 == option.status) continue;
            return true;
        }
        return false;
    }

    public boolean hasValueChanged() {
        return this.valueChanged;
    }

    public void minimizeMemoryFootPrint() {
        super.minimizeMemoryFootPrint();
        if (16 != this.status) {
            ((ArrayList)this.options).trimToSize();
            if (0 != this.options.size()) {
                this.value = null;
            }
        }
    }

    public Option removeLastChild() {
        Option oldOption = (Option)this.options.remove(this.options.size() - 1);
        ((ArrayList)this.options).trimToSize();
        return oldOption;
    }

    public Option replaceChildAt(int index, FormNode arrayOption, boolean notify) {
        if (0 == this.options.size()) {
            this.value = null;
            this.valueChanged = false;
        }
        for (int i = this.options.size(); i <= index; ++i) {
            this.options.add(null);
        }
        Option result = (Option)this.options.get(index);
        this.options.set(index, arrayOption);
        if (result != null) {
            ((Option)arrayOption).referenceName = result.referenceName;
        } else {
            ((ArrayOption)arrayOption).setReferenceName((Option)arrayOption.parent, arrayOption.referenceName, index, false);
        }
        if (notify) {
            this.setStatus(2);
            this.setParentStatus(2);
        }
        return result;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLiteral(String value) {
        boolean hasChildren = false;
        for (int i = 0; i < this.options.size(); ++i) {
            Option oldOption = (Option)this.options.get(i);
            if (null != oldOption && 16 != oldOption.status) {
                oldOption.dispose();
            }
            hasChildren = true;
        }
        this.options = new ArrayList(0);
        this.setStatus(hasChildren ? 8 : 2);
        this.value = value;
        this.valueChanged = true;
        this.setParentStatus(2);
    }

    public boolean shouldParseChild(String childName, String uri, FormNamespaceSupport namespace, int childIndex) {
        String alternateName = childName;
        String[] parts = childName.split(":");
        if (2 == parts.length) {
            String defaultURI = this.getNamespaceURIFromPrefix("");
            if (defaultURI.equals(uri)) {
                alternateName = parts[1];
            }
        } else {
            alternateName = this.getPrefixFromNamespaceURI(uri) + ":" + childName;
        }
        return this.shouldParseChild(this.getChild(childIndex), childName, alternateName, new Integer(childIndex).toString());
    }

    public void validateReference(Action action) {
        int nameLength = action.getNumberOfRelativeReferenceElements();
        switch (action.getReferenceType()) {
            case 393216: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 == nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.PageReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 131072: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 <= nameLength && 2 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ItemReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 65536: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 <= nameLength && 3 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.OptionReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 589824: {
                if (!action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (3 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.OptionReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            default: {
                throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
            }
        }
    }

    FormNode getChild(String uriQName, boolean create, String prefixQName, FormNode namespaceNode) {
        throw new UnsupportedOperationException();
    }

    FormNode getChild(Action action, int depth, boolean create) {
        Option option = null;
        int useIndex = -1;
        String[] reference = action.getURINames();
        String uriQName = reference[depth];
        int index = this.arrayIndex(uriQName);
        if (-1 == index) {
            int lastDeleted = -1;
            for (int i = 0; i < this.options.size(); ++i) {
                option = (Option)this.getChild(i);
                if (null == option) continue;
                if (option.getURIQualifiedName().equals(uriQName)) {
                    if (16 == option.status) {
                        lastDeleted = -1;
                        continue;
                    }
                    useIndex = i;
                    break;
                }
                option = null;
            }
            if (-1 != lastDeleted && create) {
                option = (Option)this.options.get(lastDeleted);
            }
            if (null == option && create) {
                String newQName;
                String uri;
                FormNamespaceSupport namespace = null;
                String prefixName = action.getPrefixNames()[depth];
                String[] name = prefixName.split(":");
                if (1 == name.length) {
                    uri = this.getNamespaceURI();
                    newQName = name[0];
                } else {
                    uri = uriQName.split("#")[0];
                    if ("null".equals(name[0])) {
                        newQName = name[1];
                        namespace = new FormNamespaceSupport();
                        namespace.declarePrefix("", "");
                    } else {
                        newQName = prefixName;
                    }
                }
                int newIndex = -1 == useIndex ? this.getChildCount() : useIndex;
                option = new ArrayOption(this, uri, newQName, newIndex, null, namespace, false);
                option.status = 4;
                if (-1 == useIndex) {
                    this.addChild(option, true);
                } else {
                    this.replaceChildAt(useIndex, option, true);
                }
            }
        } else {
            if (1 == this.status) {
                if (index < this.options.size()) {
                    option = (Option)this.getChild(index);
                }
            } else {
                int count = 0;
                for (int i = 0; i < this.options.size(); ++i) {
                    option = (Option)this.getChild(i);
                    if (null != option && 16 == option.status) {
                        if (count != index) continue;
                        option = null;
                        break;
                    }
                    if (count == index) break;
                    ++count;
                }
                if (count == this.options.size()) {
                    option = null;
                }
            }
            if (null == option && create) {
                option = new ArrayOption(this, "", ARRAY_OPTION_ID, index, null, null, false);
                option.status = 4;
                for (int i = this.options.size(); i <= index; ++i) {
                    this.addChild(null, false);
                }
                this.replaceChildAt(index, option, true);
            }
        }
        if (null != option) {
            if (depth == reference.length - 1) {
                return option;
            }
            return option.getChild(action, ++depth, create);
        }
        return null;
    }

    void removeChild(String uriQName, boolean notify) {
        throw new UnsupportedOperationException();
    }

    private void initialize(FormNode parent, String uri) {
        this.identifier = "";
        if (parent instanceof Item) {
            this.optionRoot = this;
            this.parseMaps = parent.getParseMaps(this.referenceName);
        } else if (parent instanceof XFDL) {
            this.optionRoot = null;
            this.parseMaps = new HashMap(0);
        } else {
            this.optionRoot = ((Option)parent).optionRoot;
        }
    }
}

