/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.model;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.model.Page;
import com.ibm.form.api.internal.utilities.FormLogger;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class Item
extends FormNode {
    private Map options = new LinkedHashMap(0);

    public static String isItem(String uri, Attributes attributes) {
        String sid = Item.getSidAndValidateNamespace(uri, attributes);
        if ("global".equals(sid)) {
            if (null != sid) {
                FormNode.errorCode = LocalizedStringFormat.bind(Messages.XmlElementValueError.toStringAsRequest(), (Object)"global", (Object)sid);
            }
            return null;
        }
        return sid;
    }

    static String getSidAndValidateNamespace(String uri, Attributes attributes) {
        String attributeURI = null;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            if (!"sid".equals(attributes.getLocalName(i))) continue;
            attributeURI = attributes.getURI(i);
            if (attributeURI.equals("")) {
                attributeURI = uri;
            }
            if (FormNamespaceSupport.isXFDLNamespace(attributeURI)) {
                return attributes.getValue(i);
            }
            FormNode.errorCode = LocalizedStringFormat.bind(Messages.XfldNamespaceError.toStringAsRequest(), (Object)attributeURI);
            return null;
        }
        FormNode.errorCode = LocalizedStringFormat.bind(Messages.InvalidXmlAttribute.toStringAsRequest(), (Object)"sid", null);
        return null;
    }

    public Item(Page parent, String uri, String qName, String sid, Attributes attributes, FormNamespaceSupport namespace) {
        super(3, parent, uri, qName, attributes, namespace);
        this.qualifiedName = sid;
        this.referenceName = sid;
        this.parseMaps = parent.getParseMaps(sid);
    }

    public void addChild(FormNode option, boolean notify) {
        String key = option.getURIQualifiedName();
        Option oldOption = (Option)this.options.put(key, option);
        if (null != oldOption) {
            Logger logger = FormLogger.getLogger();
            if (4 != option.status) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Incorrect new option state " + option.getReference(null));
                }
                throw new IllegalStateException();
            }
            if (16 != oldOption.status && logger.isLoggable(Level.FINE)) {
                logger.fine("Option already defined " + oldOption.getReference(null));
                this.options.put(key, oldOption);
            }
        }
        if (notify) {
            this.setStatus(2);
            this.setParentStatus(2);
        }
    }

    public void dispose() {
        super.dispose();
        if (null != this.options) {
            FormNode[] children = this.getAllChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].dispose();
                this.options.remove(children[i].getURIQualifiedName());
            }
            this.options = null;
        }
    }

    public FormNode[] getAllChildren() {
        Object[] children = this.options.values().toArray();
        FormNode[] newArray = new Option[children.length];
        System.arraycopy(children, 0, newArray, 0, newArray.length);
        return newArray;
    }

    public String getReference(FormNode contextNode) {
        if (this.parent.equals(contextNode)) {
            return this.referenceName;
        }
        return this.parent.getReference(contextNode) + "." + this.referenceName;
    }

    public FormNode getStartNode(Action action) {
        switch (action.getReferenceType()) {
            case 393216: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() + 1);
            }
            case 131072: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements());
            }
            case 65536: 
            case 589824: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() - 1);
            }
        }
        throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
    }

    public boolean shouldParseChild(String childName, String uri, FormNamespaceSupport namespace) {
        String alternateName = childName;
        String[] parts = childName.split(":");
        if (2 == parts.length) {
            String defaultURI = this.getNamespaceURIFromPrefix("");
            if (defaultURI.equals(uri)) {
                alternateName = parts[1];
            }
        } else {
            alternateName = this.getPrefixFromNamespaceURI(uri) + ":" + childName;
        }
        return this.shouldParseChild(this.getChild(childName), childName, alternateName, alternateName);
    }

    public void validateReference(Action action) {
        int nameLength = action.getNumberOfRelativeReferenceElements();
        switch (action.getReferenceType()) {
            case 393216: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 == nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.PageReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 131072: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 <= nameLength && 2 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ItemReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 65536: 
            case 589824: {
                if (65536 == action.getReferenceType() ? action.hasArrayIndices() : !action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 <= nameLength && 3 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ItemReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            default: {
                throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
            }
        }
    }

    FormNode getChild(String uriQName, boolean create, String prefixQName, FormNode namespaceNode) {
        Option option = (Option)this.options.get(uriQName);
        if (null != option && 16 == option.status && create) {
            option = null;
            this.options.remove(uriQName);
        }
        if (null == option && create) {
            String newQName;
            String uri;
            if (null == namespaceNode) {
                namespaceNode = this;
            }
            FormNamespaceSupport namespace = null;
            String[] name = prefixQName.split(":");
            if (1 == name.length) {
                uri = this.getXFDLNamespaceURI();
                newQName = name[0];
            } else {
                uri = uriQName.split("#")[0];
                if ("null".equals(name[0])) {
                    namespace = new FormNamespaceSupport();
                    namespace.declarePrefix("", "");
                    newQName = name[1];
                } else {
                    newQName = prefixQName;
                }
            }
            option = new Option(this, uri, newQName, null, namespace);
            this.addChild(option, true);
        }
        return option;
    }

    void removeChild(String uriQName, boolean notify) {
        if (null == this.options) {
            throw new IllegalStateException();
        }
        this.removeChild((FormNode)this.options.get(uriQName), notify);
    }
}

