/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.model;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.model.XFDL;
import com.ibm.form.api.internal.parser.sax.FormHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParser;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class FormNode {
    public static final String ATTRIBUTE_SID_ID = "sid";
    public static final String ATTRIBUTE_ID = "id";
    public static final int STATUS_ORIGINAL = 1;
    public static final int STATUS_UPDATED = 2;
    public static final int STATUS_NEW = 4;
    public static final int STATUS_REPLACED = 8;
    public static final int STATUS_DELETED = 16;
    public static String errorCode;
    public FormNode parent;
    public int status = 1;
    int nodeType;
    String qualifiedName;
    String qName;
    String referenceName;
    String uri;
    Attributes attributes;
    boolean needParse = true;
    FormNamespaceSupport namespace;
    Map parseMaps = new HashMap();
    private XFDLParser parser;

    public static String getAttributeValue(Attributes attributes, String attributeID) {
        if (null == attributes) {
            return "";
        }
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            if (!attributeID.equals(attributes.getLocalName(i))) continue;
            return attributes.getValue(i);
        }
        return "";
    }

    public FormNode(int nodeType, FormNode parent, String uri, String qName, Attributes attributes, FormNamespaceSupport namespace) {
        if (null == parent) {
            throw new IllegalArgumentException(Messages.ParameterNull.toStringAsRequest());
        }
        this.initialize(nodeType, parent, uri, qName, attributes, namespace, null == parent ? null : parent.getParser());
    }

    FormNode(int nodeType, String uri, String qName, Attributes attributes, FormNamespaceSupport namespace, XFDLParser parser) {
        if (null == parser) {
            throw new IllegalArgumentException(Messages.ParameterNull.toStringAsRequest());
        }
        this.initialize(nodeType, null, uri, qName, attributes, namespace, parser);
    }

    public void add(boolean notify) {
        this.parent.addChild(this, notify);
    }

    public abstract void addChild(FormNode var1, boolean var2);

    public void dispose() {
        if (null != this.parent) {
            this.setParentStatus(2);
        }
        this.parent = null;
        this.attributes = null;
        this.namespace = null;
        this.parser = null;
        this.status = 16;
    }

    public String generateXML(int level, String[] indent, Set namespacePrefixes) {
        String outName = this.getLocalName();
        FormNode[] children = this.getAllChildren();
        if (0 != children.length) {
            indent = this.expandIndentString(level, indent);
            String result = this.generateXMLStartElement(indent[level], outName, false, namespacePrefixes);
            for (int i = 0; i < children.length; ++i) {
                if (null == children[i]) continue;
                result = result + "\n" + children[i].generateXML(level + 1, indent, new HashSet(0));
            }
            result = result + "\n" + this.generateXMLEndElement(indent[level], outName);
            return result;
        }
        return this.generateXMLStartElement(indent[level], outName, true, namespacePrefixes);
    }

    public FormNamespaceSupport getActiveNamespace() {
        FormNode node;
        FormNamespaceSupport allNamespace = new FormNamespaceSupport();
        if (null != this.namespace) {
            allNamespace.addNamespaceEntries(this.namespace);
        }
        if (null != (node = this.parent)) {
            FormNamespaceSupport nodeNamespace = node.getActiveNamespace();
            allNamespace.addNamespaceEntries(nodeNamespace);
        }
        return allNamespace;
    }

    public abstract FormNode[] getAllChildren();

    public String getAttributeDescription() {
        String result = "";
        if (null == this.attributes) {
            return result;
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            result = result + " " + this.attributes.getQName(i) + "=\"" + this.attributes.getValue(i) + "\"";
        }
        return result;
    }

    public String getAttributeValue(String attributeID) {
        return FormNode.getAttributeValue(this.attributes, attributeID);
    }

    public FormNode getChild(String uriQName) {
        return this.getChild(uriQName, false, null, null);
    }

    public FormNamespaceSupport getDefinedNamespace() {
        return this.namespace;
    }

    public XFDL getFormNode() {
        FormNode node = this;
        FormNode parentalUnit = node.getParent();
        while (null != parentalUnit) {
            node = parentalUnit;
            parentalUnit = node.getParent();
        }
        return (XFDL)node;
    }

    public String getLiteral() {
        return null;
    }

    public String getLocalName() {
        String[] name = this.qName.split(":");
        return 1 == name.length ? this.qName : name[1];
    }

    public String getNamespaceDescription(Set prefixes) {
        if (null == prefixes) {
            return this.getActiveNamespace().getNamespaceDescription();
        }
        String result = "";
        if (prefixes.isEmpty()) {
            if (null != this.namespace) {
                return this.namespace.getNamespaceDescription();
            }
            return result;
        }
        FormNamespaceSupport ns = this.getActiveNamespace();
        Vector keys = new Vector(prefixes);
        Collections.sort(keys);
        Iterator it = ((AbstractList)keys).iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            result = result + ns.getNamespaceDescription(prefix);
        }
        return result;
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public String getNamespaceURIFromPrefix(String prefix) {
        String uri;
        if (null != this.namespace && null != (uri = this.namespace.getNamespaceURI(prefix))) {
            return uri;
        }
        if (null != this.parent) {
            return this.parent.getNamespaceURIFromPrefix(prefix);
        }
        return null;
    }

    public FormNode[] getNodes(Action action, int index, boolean create) {
        FormNode[] result = new FormNode[]{};
        if (2 < index) {
            FormNode child = ((Option)this).getChild(action, index, create);
            if (null != child) {
                result = new FormNode[]{child};
            }
            return result;
        }
        String uriQName = action.getURINames()[index];
        String prefixQName = action.getPrefixNames()[index];
        if (2 == index) {
            if (action.hasArrayIndices()) {
                if (prefixQName.equals("*")) {
                    Option[] children = (Option[])this.getAllChildren();
                    FormNode[] newArray = new FormNode[result.length + children.length];
                    System.arraycopy(result, 0, newArray, 0, result.length);
                    int nextIndex = result.length;
                    for (int i = 0; i < children.length; ++i) {
                        Option child;
                        if (null == children[i] || null == (child = (Option)children[i].getChild(action, 3, create))) continue;
                        newArray[nextIndex++] = child;
                    }
                    if (nextIndex != newArray.length) {
                        FormNode[] array = new FormNode[nextIndex];
                        System.arraycopy(newArray, 0, array, 0, nextIndex);
                        newArray = array;
                    }
                    result = newArray;
                } else {
                    Option child = (Option)this.getChild(uriQName, create, prefixQName, action.getNamespaceNode());
                    if (null != child && 16 != child.status && null != (child = (Option)child.getChild(action, 3, create)) && 16 != child.status) {
                        result = new FormNode[]{child};
                    }
                }
            } else if (prefixQName.equals("*")) {
                List<FormNode> list = Arrays.asList(this.getAllChildren());
                Iterator<FormNode> it = list.iterator();
                while (it.hasNext()) {
                    FormNode node = it.next();
                    if (null != node) continue;
                    list.remove(node);
                }
                result = (FormNode[])list.toArray();
            } else {
                FormNode child = this.getChild(uriQName, create, prefixQName, action.getNamespaceNode());
                if (null != child && 16 != child.status) {
                    result = new FormNode[]{child};
                }
            }
            return result;
        }
        if (prefixQName.equals("*")) {
            if (action.getPrefixNames().length > ++index) {
                FormNode[] allChildren = this.getAllChildren();
                for (int i = 0; i < allChildren.length; ++i) {
                    FormNode[] children;
                    if (null == allChildren[i] || 0 == (children = allChildren[i].getNodes(action, index, create)).length) continue;
                    FormNode[] newResult = new FormNode[children.length + result.length];
                    System.arraycopy(result, 0, newResult, 0, result.length);
                    System.arraycopy(children, 0, newResult, result.length, children.length);
                    result = newResult;
                }
            }
        } else {
            FormNode child = this.getChild(uriQName, create, prefixQName, action.getNamespaceNode());
            if (null != child && 16 != child.status) {
                result = action.getPrefixNames().length > ++index ? child.getNodes(action, index, create) : new FormNode[]{child};
            }
        }
        return result;
    }

    public FormNode getParent() {
        return this.parent;
    }

    public Map getParseMaps(String childName) {
        HashMap newMap = new HashMap();
        if (this.parseMaps.containsKey("**")) {
            newMap.put("**", this.parseMaps.get("**"));
        }
        if (this.parseMaps.containsKey("*")) {
            newMap.putAll((Map)this.parseMaps.get("*"));
        }
        if (this.parseMaps.containsKey(childName)) {
            newMap.putAll((Map)this.parseMaps.get(childName));
        }
        return newMap;
    }

    public Map getParseMaps(String childName, String childIndex) {
        Map map1 = this.getParseMaps(childName);
        Map map2 = this.getParseMaps(childIndex);
        map1.putAll(map2);
        return map1;
    }

    public XFDLParser getParser() {
        return this.parser;
    }

    public String getPrefix() {
        String[] name = this.qName.split(":");
        return 1 == name.length ? null : name[0];
    }

    public String getPrefixFromNamespaceURI(String uri) {
        String prefix;
        if (null != this.namespace && null != (prefix = this.namespace.getNamespacePrefix(uri))) {
            return prefix;
        }
        if (null != this.parent) {
            return this.parent.getPrefixFromNamespaceURI(uri);
        }
        return null;
    }

    public String getPrefixQualifiedName() {
        return this.qName;
    }

    public String getReference(FormNode contextNode) {
        return "";
    }

    public String[] getReferenceParts() {
        String reference = this.getReference(null);
        String[] firstPart = reference.split("\\.");
        String[] secondPart = reference.split("\\[");
        int newLength = 0;
        if (3 == firstPart.length) {
            newLength = 3;
            String name = firstPart[2];
            int index = name.indexOf("[");
            if (-1 != index) {
                firstPart[2] = name.substring(0, index);
            }
        }
        if (1 != secondPart.length) {
            newLength += secondPart.length - 1;
            for (int i = 1; i < secondPart.length; ++i) {
                String name = secondPart[i];
                secondPart[i] = name.substring(0, name.indexOf("]"));
            }
        }
        String[] newArray = new String[newLength];
        System.arraycopy(firstPart, 0, newArray, 0, firstPart.length);
        if (3 != newArray.length) {
            System.arraycopy(secondPart, 1, newArray, firstPart.length, secondPart.length - 1);
        }
        return newArray;
    }

    public void getRequiredPrefixes(Set result) {
        FormNamespaceSupport ns;
        String prefix = this.getPrefix();
        if (null != prefix && (null == (ns = this.getDefinedNamespace()) || null != ns && !ns.containsPrefix(prefix))) {
            result.add(prefix);
        }
        FormNode[] children = this.getAllChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].getRequiredPrefixes(result);
        }
    }

    public abstract FormNode getStartNode(Action var1);

    public int getType() {
        return this.nodeType;
    }

    public String getURIQualifiedName() {
        return this.qualifiedName;
    }

    public String getXFDLNamespaceURI() {
        String uri;
        if (null != this.namespace && null != (uri = this.namespace.getXFDLNamespaceURI())) {
            return uri;
        }
        if (this.parent != null) {
            return this.parent.getXFDLNamespaceURI();
        }
        return "http://www.ibm.com/xmlns/prod/XFDL/7.6";
    }

    public void minimizeMemoryFootPrint() {
        this.parseMaps.clear();
    }

    public boolean nullChildEntryExists() {
        FormNode[] children = this.getAllChildren();
        for (int i = 0; i < children.length; ++i) {
            if (null == children[i]) {
                return true;
            }
            if (!children[i].nullChildEntryExists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List actions) throws ParserConfigurationException, SAXException, IOException {
        XFDLParser parser = this.getParser();
        if (!parser.process(this, actions, true)) {
            FormHandler handler = new FormHandler(this.getFormNode());
            try {
                parser.parse(handler, this, actions);
            }
            finally {
                handler.dispose();
            }
            parser.process(this, actions, false);
        }
    }

    public void setChildrenStatus(int newStatus) {
        FormNode[] children = this.getAllChildren();
        for (int i = 0; i < children.length; ++i) {
            if (null == children[i]) continue;
            children[i].setStatus(newStatus);
            children[i].setChildrenStatus(newStatus);
        }
    }

    public void setLiteral(String value) {
    }

    public void setNamespace(FormNamespaceSupport namespace) {
        this.namespace = namespace;
    }

    public void setParentStatus(int newStatus) {
        if (null != this.parent) {
            this.parent.setStatus(newStatus);
            this.parent.setParentStatus(newStatus);
        }
    }

    public void setParseMaps(Map maps) {
        this.parseMaps = maps;
    }

    public void setStatus(int newStatus) {
        block0 : switch (this.status) {
            case 16: {
                break;
            }
            case 8: {
                switch (newStatus) {
                    case 16: {
                        this.status = newStatus;
                        break block0;
                    }
                    case 2: 
                    case 8: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException(new Integer(newStatus).toString());
            }
            case 4: {
                switch (newStatus) {
                    case 8: {
                        this.status = newStatus;
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException(new Integer(newStatus).toString());
            }
            case 1: 
            case 2: {
                switch (newStatus) {
                    case 2: 
                    case 8: 
                    case 16: {
                        this.status = newStatus;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(new Integer(newStatus).toString());
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        switch (this.status) {
            case 1: {
                String status = " Original";
                break;
            }
            case 2: {
                String status = " Updated";
                break;
            }
            case 16: {
                String status = " Deleted";
                break;
            }
            case 4: {
                String status = " New";
                break;
            }
            case 8: {
                String status = " Replaced";
                break;
            }
            default: {
                throw new IllegalArgumentException(new Integer(this.status).toString());
            }
        }
        return this.qName + (String)var1_1;
    }

    public abstract void validateReference(Action var1);

    String[] expandIndentString(int level, String[] indent) {
        if (level >= indent.length) {
            int oldLength = indent.length;
            String[] newArray = new String[oldLength + 4];
            System.arraycopy(indent, 0, newArray, 0, oldLength);
            indent = newArray;
        }
        int lastIndent = 1;
        do {
            if (!"".equals(indent[lastIndent]) && null != indent[lastIndent]) continue;
            indent[lastIndent] = indent[lastIndent - 1] + indent[1];
        } while (++lastIndent < indent.length);
        return indent;
    }

    String generateXMLEndElement(String indent, String name) {
        return indent + "</" + name + ">";
    }

    String generateXMLStartElement(String indent, String name, boolean emptyElement, Set namespacePrefixes) {
        String result = indent + "<" + name;
        result = result + this.getNamespaceDescription(namespacePrefixes);
        result = result + this.getAttributeDescription();
        if (emptyElement) {
            return result + "/>";
        }
        return result + ">";
    }

    abstract FormNode getChild(String var1, boolean var2, String var3, FormNode var4);

    abstract void removeChild(String var1, boolean var2);

    void removeChild(FormNode formNode, boolean notify) {
        if (null == formNode) {
            throw new IllegalStateException();
        }
        if (16 != formNode.status) {
            formNode.setStatus(16);
            FormNode[] children = formNode.getAllChildren();
            for (int i = 0; i < children.length; ++i) {
                if (null == children[i]) continue;
                children[i].dispose();
            }
            if (notify) {
                this.setParentStatus(2);
            }
            this.setStatus(2);
        }
    }

    boolean shouldParseChild(FormNode formNode, String primaryKey, String secondaryKey, String tertiaryKey) {
        if (null != formNode) {
            switch (formNode.status) {
                case 4: 
                case 8: 
                case 16: {
                    return false;
                }
            }
        }
        return this.parseMapContains(primaryKey, secondaryKey, tertiaryKey);
    }

    FormNode walkUp(int depth) {
        FormNode parent = this.getParent();
        if (null == parent) {
            if (0 != depth) {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(depth).toString()));
            }
            return this;
        }
        if (0 == depth) {
            return this;
        }
        return parent.walkUp(--depth);
    }

    private void initialize(int nodeType, FormNode parent, String uri, String qName, Attributes attributes, FormNamespaceSupport namespace, XFDLParser parser) {
        String prefix;
        this.parent = parent;
        this.nodeType = nodeType;
        this.qName = qName;
        String[] name = qName.split(":");
        this.qualifiedName = uri + "#" + name[name.length - 1];
        this.referenceName = 2 == name.length ? qName : (null == (prefix = this.getPrefixFromNamespaceURI(uri)) || this.getPrefixFromNamespaceURI(this.getXFDLNamespaceURI()).equals(prefix) ? qName : prefix + ":" + qName);
        this.uri = uri;
        this.attributes = attributes;
        this.namespace = namespace;
        this.parser = parser;
    }

    private boolean parseMapContains(String primaryKey, String secondaryKey, String tertiaryKey) {
        if (this.parseMaps.containsKey(primaryKey)) {
            return true;
        }
        if (this.parseMaps.containsKey("*")) {
            return true;
        }
        if (this.parseMaps.containsKey("**")) {
            return true;
        }
        if (this.parseMaps.containsKey(secondaryKey)) {
            return true;
        }
        return this.parseMaps.containsKey(tertiaryKey);
    }
}

