/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.model;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import org.xml.sax.Attributes;

public class ArrayOption
extends Option {
    public ArrayOption(Option parent, String uri, String qName, int index, Attributes attributes, FormNamespaceSupport namespace, boolean instanceOption) {
        super(parent, uri, qName, attributes, namespace, 5);
        this.setReferenceName(parent, qName, index, instanceOption);
        this.parseMaps = parent.getParseMaps(this.referenceName, new Integer(index).toString());
    }

    public String getReference(FormNode contextNode) {
        if (this.parent.equals(contextNode)) {
            return "[" + this.referenceName + "]";
        }
        return this.parent.getReference(contextNode) + "[" + this.referenceName + "]";
    }

    public FormNode getStartNode(Action action) {
        switch (action.getReferenceType()) {
            case 393216: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() + 3);
            }
            case 131072: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() + 2);
            }
            case 65536: {
                return this.walkUp(action.getNumberOfRelativeReferenceElements() + 1);
            }
            case 589824: {
                int numberNameParts = action.getNumberOfRelativeReferenceElements();
                if (0 == numberNameParts) {
                    return this;
                }
                return this.walkUp(numberNameParts + 1);
            }
        }
        throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
    }

    public void validateReference(Action action) {
        int nameLength = action.getNumberOfRelativeReferenceElements();
        switch (action.getReferenceType()) {
            case 393216: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 == nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.PageReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 131072: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 <= nameLength && 2 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ItemReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 65536: {
                if (action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (1 <= nameLength && 3 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.OptionReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            case 589824: {
                if (!action.hasArrayIndices()) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.UnexpectedSubOptions.toStringAsRequest(), (Object)action.getRelativeReference()));
                }
                if (3 >= nameLength) break;
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.OptionReferenceExpected.toStringAsRequest(), (Object)action.getRelativeReference()));
            }
            default: {
                throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(action.getReferenceType()).toString()));
            }
        }
    }

    void setReferenceName(Option parent, String referenceName, int index, boolean instanceOption) {
        Option[] children = (Option[])parent.getAllChildren();
        if ("ae".equals(referenceName) && 0 != index) {
            this.referenceName = new Integer(index).toString();
        } else {
            for (int i = 0; i < children.length; ++i) {
                if (null == children[i] || !this.referenceName.equals(children[i].referenceName) || i == index) continue;
                this.referenceName = new Integer(index).toString();
                break;
            }
        }
        if (instanceOption) {
            this.identifier = FormNode.getAttributeValue(this.attributes, "id");
        }
    }

    FormNode walkUp(int depth) {
        if (0 == depth) {
            return this;
        }
        return this.optionRoot.walkUp(--depth);
    }
}

