/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.action;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.ArrayOption;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class ActionXMLModelInstance
extends Action {
    private static final String XML_MODEL_ROOT = "global.global.xmlmodel[instances]";
    String instanceId;
    boolean searchByInstanceID;
    boolean searchByReference;
    Option foundInstance;
    Option foundChild;
    int replaceNode;
    boolean autoCreate;
    boolean initialReferenceNull;
    int firstParseNumber;

    public boolean postParse(FormNode node, boolean overrideAutoCreate) throws IOException, ParserConfigurationException, SAXException {
        this.resolveNamespace(node);
        if (this.searchByInstanceID) {
            this.getNodesByInstanceID(node);
        }
        if (this.searchByReference) {
            this.getNodesByReference(node, overrideAutoCreate);
            this.foundInstance = null == this.foundChild ? null : (16 == this.foundChild.status ? null : (Option)this.foundChild.getParent());
        } else if (null != this.foundInstance && 16 != this.foundInstance.status) {
            if (0 == this.foundInstance.getChildCount()) {
                this.foundInstance.addChild(new ArrayOption(this.foundInstance, this.foundInstance.getNamespaceURI(), "ae", 0, null, null, false), true);
            }
            this.foundChild = (Option)this.foundInstance.getChild(0);
        } else {
            this.foundChild = null;
            this.foundInstance = null;
        }
        if (null == this.foundInstance) {
            if (node.getParser().getParserData().getNumberOfPasses() == this.firstParseNumber) {
                return false;
            }
            return false;
        }
        return this.doit();
    }

    public boolean preParse(FormNode node) {
        if (this.preParseComplete) {
            return true;
        }
        boolean result = super.preParse(node);
        if (result) {
            String[] oldValue = this.parseMapEntry;
            String[] newEntry = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, newEntry, 0, oldValue.length);
            newEntry[oldValue.length] = "**";
            this.parseMapEntry = newEntry;
        }
        this.firstParseNumber = node.getParser().getParserData().getNumberOfPasses();
        return result;
    }

    abstract boolean doit() throws IOException, ParserConfigurationException, SAXException;

    void initialize(String instanceID, String reference, FormNode namespaceNode, boolean replaceNode, boolean autoCreate) {
        if (null == instanceID && null == reference) {
            throw new IllegalArgumentException(Messages.ParameterNull.toStringAsRequest());
        }
        this.searchByInstanceID = null != instanceID;
        this.searchByReference = null != reference;
        this.instanceId = null == instanceID ? "" : instanceID;
        this.initialReferenceNull = null == reference;
        String root = XML_MODEL_ROOT + ("".equals(this.instanceId) ? "[0]" : "[*]");
        if (null == reference) {
            this.initialize(root, 589824, namespaceNode);
        } else {
            if (-1 != reference.indexOf("*")) {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)reference));
            }
            if (reference.startsWith(XML_MODEL_ROOT)) {
                this.initialize(reference, 589824, namespaceNode);
                this.searchByInstanceID = false;
            } else {
                if (0 != reference.indexOf("[")) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)reference));
                }
                this.initialize(root + reference, 589824, namespaceNode);
            }
        }
        this.replaceNode = replaceNode ? 1 : 2;
        this.autoCreate = autoCreate;
    }

    private void getNodesByInstanceID(FormNode node) throws IOException, ParserConfigurationException, SAXException {
        int length = this.getURINames().length;
        String[] origURINames = new String[length];
        System.arraycopy(this.getURINames(), 0, origURINames, 0, length);
        String uri = node.getXFDLNamespaceURI();
        if (length > 4) {
            this.resetURINameParts(new String[]{"global", "global", uri + "#xmlmodel", uri + "#instances"});
        }
        this.foundInstance = null;
        FormNode[] nodes = this.getNodes(node, false);
        if (1 != nodes.length) {
            this.resetURINameParts(origURINames);
            return;
        }
        ArrayOption modelOption = (ArrayOption)nodes[0];
        FormNode[] children = modelOption.getAllChildren();
        for (int i = 0; i < children.length; ++i) {
            if (null == children[i]) {
                if (0 != i || !"".equals(this.instanceId)) continue;
                break;
            }
            ArrayOption instance = (ArrayOption)children[i];
            if (!"".equals(this.instanceId) && !instance.getInstanceIdentifier().equals(this.instanceId)) continue;
            this.foundInstance = instance;
            break;
        }
        this.resetURINameParts(origURINames);
    }

    private void getNodesByReference(FormNode node, boolean overrideAutoCreate) throws IOException, ParserConfigurationException, SAXException {
        int startIndex;
        FormNode startNode;
        boolean autoCreate;
        if (this.searchByInstanceID && null == this.foundInstance) {
            return;
        }
        boolean bl = autoCreate = overrideAutoCreate ? false : this.autoCreate;
        if (null == this.foundInstance) {
            startNode = node;
            startNode = startNode.getStartNode(this);
            startIndex = 0;
        } else {
            startNode = this.foundInstance;
            startIndex = 5;
        }
        FormNode[] nodes = startNode.getNodes(this, startIndex, autoCreate);
        this.foundChild = 1 == nodes.length ? (Option)nodes[0] : null;
    }
}

