/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.action;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class ActionXFormsModelsInstance
extends Action {
    private static final String XFORMSMODELS_ROOT = "global.global.xformsmodels";
    private static final int UPDATE_MODE_MASK = 7;
    String modelID;
    String instanceXPath;
    String instanceId;
    Option foundInstance;
    Option foundChild;
    int updateMode;
    boolean autoCreate;
    int firstParseNumber;

    public boolean postParse(FormNode node, boolean overrideAutoCreate) throws IOException, ParserConfigurationException, SAXException {
        this.resolveNamespace(node);
        this.getNodesByInstanceID(node);
        if (null == this.foundInstance) {
            if (node.getParser().getParserData().getNumberOfPasses() == this.firstParseNumber) {
                return false;
            }
            throw new IllegalArgumentException(Messages.XformsmodelsNodeNotFound.toStringAsRequest());
        }
        this.getNodesByReference(overrideAutoCreate);
        if (null == this.foundChild) {
            if (node.getParser().getParserData().getNumberOfPasses() == this.firstParseNumber) {
                return false;
            }
            throw new IllegalArgumentException(Messages.XformsmodelsNodeNotFound.toStringAsRequest());
        }
        return this.doit();
    }

    public boolean preParse(FormNode node) {
        if (this.preParseComplete) {
            return true;
        }
        boolean result = super.preParse(node);
        if (result) {
            String[] oldValue = this.parseMapEntry;
            String[] newEntry = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, newEntry, 0, oldValue.length);
            newEntry[oldValue.length] = "**";
            this.parseMapEntry = newEntry;
        }
        this.firstParseNumber = node.getParser().getParserData().getNumberOfPasses();
        return result;
    }

    abstract boolean doit() throws IOException, ParserConfigurationException, SAXException;

    void initialize(String modelID, String instanceXPath, FormNode namespaceNode, int updateMode, boolean autoCreate) {
        String string = this.modelID = null == modelID ? "" : modelID;
        if (-1 != this.modelID.indexOf("*")) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)this.modelID));
        }
        String[] referenceParts = this.checkXPathSupport(instanceXPath);
        this.foundInstance = null;
        this.foundChild = null;
        this.updateMode = updateMode & 7;
        if (0 == this.updateMode) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)new Integer(updateMode).toString()));
        }
        this.autoCreate = autoCreate;
        String reference = "global.global.xformsmodels[*][*]";
        for (int i = 0; i < referenceParts.length; ++i) {
            reference = reference + referenceParts[i];
        }
        this.initialize(reference, 589824, namespaceNode);
    }

    private void checkPrefixName(int startIndex, String[] tokens) {
        for (int i = startIndex; i < tokens.length; ++i) {
            String prefixName = tokens[i];
            String[] nameParts = prefixName.split(":");
            if (1 == nameParts.length) {
                if (-1 != this.arrayIndex(nameParts[0])) {
                    throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)nameParts[0]));
                }
                prefixName = "null:" + prefixName;
            } else if ("null".equals(nameParts[0])) {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)nameParts[0]));
            }
            tokens[i] = "[" + prefixName + "]";
        }
    }

    private String[] checkXPathSupport(String theInstanceXPath) {
        this.instanceXPath = theInstanceXPath;
        if (null != theInstanceXPath && -1 != theInstanceXPath.indexOf("*")) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)theInstanceXPath));
        }
        if (null == theInstanceXPath || "".equals(theInstanceXPath) || ".".equals(theInstanceXPath)) {
            this.instanceId = "";
            return new String[]{"[0]"};
        }
        String[] tokens = theInstanceXPath.split("\\/");
        if (tokens[0].startsWith("instance('")) {
            String[] parts = tokens[0].split("'");
            if (3 != parts.length) {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ParameterInvalid.toStringAsRequest(), (Object)theInstanceXPath));
            }
            if (!parts[2].equals(")")) {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ParameterInvalid.toStringAsRequest(), (Object)theInstanceXPath));
            }
            this.instanceId = parts[1];
            if (" ".equals(this.instanceId) || ".".equals(this.instanceId)) {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ParameterInvalid.toStringAsRequest(), (Object)theInstanceXPath));
            }
            tokens[0] = "[0]";
            this.checkPrefixName(1, tokens);
            return tokens;
        }
        if (tokens[0].equals("")) {
            this.instanceId = "";
            String[] newArray = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, newArray, 0, newArray.length);
            this.checkPrefixName(0, newArray);
            return newArray;
        }
        this.instanceId = "";
        String[] newArray = new String[tokens.length + 1];
        newArray[0] = "[0]";
        System.arraycopy(tokens, 0, newArray, 1, tokens.length);
        this.checkPrefixName(1, newArray);
        return newArray;
    }

    private void getNodesByInstanceID(FormNode node) throws IOException, ParserConfigurationException, SAXException {
        int length = this.getURINames().length;
        String[] origURINames = new String[length];
        System.arraycopy(this.getURINames(), 0, origURINames, 0, length);
        String name = "http://www.w3.org/2002/xforms#model";
        String[] modelRoot = new String[4];
        System.arraycopy(this.getURINames(), 0, modelRoot, 0, modelRoot.length - 1);
        modelRoot[3] = name;
        this.resetURINameParts(modelRoot);
        this.foundInstance = null;
        FormNode[] nodes = this.getNodes(node, false);
        if (1 != nodes.length) {
            this.resetURINameParts(origURINames);
            return;
        }
        Option xformsmodels = (Option)nodes[0].getParent();
        Option[] models = (Option[])xformsmodels.getAllChildren();
        Option model = null;
        for (int i = 0; i < models.length; ++i) {
            if (null == models[i] || !name.equals(models[i].getURIQualifiedName()) || !"".equals(this.modelID) && !this.modelID.equals(models[i].getInstanceIdentifier())) continue;
            model = models[i];
            break;
        }
        if (null == model) {
            this.resetURINameParts(origURINames);
            return;
        }
        Option[] instances = (Option[])model.getAllChildren();
        for (int i = 0; i < instances.length; ++i) {
            if (null == instances[i] || !"".equals(this.instanceId) && !instances[i].getInstanceIdentifier().equals(this.instanceId)) continue;
            this.foundInstance = instances[i];
            break;
        }
        this.resetURINameParts(origURINames);
    }

    private void getNodesByReference(boolean overrideAutoCreate) throws IOException, ParserConfigurationException, SAXException {
        boolean autoCreate = overrideAutoCreate ? false : this.autoCreate;
        FormNode[] nodes = this.foundInstance.getNodes(this, 5, autoCreate);
        this.foundChild = 1 == nodes.length ? (Option)nodes[0] : null;
    }
}

