/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.action;

import com.ibm.form.api.IActionWrite;
import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.XFDL;
import com.ibm.form.api.internal.parser.sax.WriteHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParser;
import com.ibm.form.api.internal.utilities.FormLogger;
import com.ibm.form.api.internal.utilities.LocalFile;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import com.ibm.form.api.internal.utilities.io.IOManager;
import com.ibm.form.api.internal.utilities.io.WriterOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ActionWrite
extends Action
implements IActionWrite {
    private OutputStream outputStream;
    private LocalFile localFile = null;
    private File writeFile = null;
    private FileOutputStream fileOutputStream = null;

    public ActionWrite(OutputStream outputStream, String encoding) throws IOException {
        if (null == outputStream) {
            throw new IllegalArgumentException(Messages.OutputSourceNull.toStringAsRequest());
        }
        this.outputStream = IOManager.getOutputStream(encoding, outputStream, true);
    }

    public ActionWrite(Writer writer, String encoding) throws IOException {
        if (null == writer) {
            throw new IllegalArgumentException(Messages.OutputSourceNull.toStringAsRequest());
        }
        this.outputStream = IOManager.getOutputStream(encoding, new WriterOutputStream(writer, "UTF-8"), true);
    }

    public ActionWrite(String filePath, String encoding) throws IOException {
        if (null == filePath) {
            throw new IllegalArgumentException(Messages.OutputSourceNull.toStringAsRequest());
        }
        this.writeFile = new File(filePath);
        if (this.writeFile.exists()) {
            if (!this.writeFile.canWrite()) {
                throw new IllegalArgumentException(Messages.OperationNotSupported.toStringAsRequest());
            }
            this.localFile = new LocalFile();
            this.fileOutputStream = new FileOutputStream(this.localFile.getCanonicalPath());
        } else {
            this.fileOutputStream = new FileOutputStream(this.writeFile);
        }
        this.outputStream = IOManager.getOutputStream(encoding, this.fileOutputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postParse(FormNode node, boolean overrideAutoCreate) throws IOException, ParserConfigurationException, SAXException {
        block11: {
            WriteHandler handler = null;
            XFDLParser parser = null;
            try {
                handler = new WriteHandler(this.outputStream, (XFDL)node);
                parser = new XFDLParser(node.getParser().getParserData().getInputSource());
                handler.setParser(parser);
                parser.parse(handler);
                if (null != this.localFile) {
                    Logger logger;
                    this.outputStream.close();
                    this.outputStream = null;
                    this.fileOutputStream.close();
                    if (!this.localFile.renameFile(this.writeFile) && (logger = FormLogger.getLogger()).isLoggable(Level.FINE)) {
                        try {
                            logger.fine("File Copy failed.  Src= " + this.localFile.getCanonicalPath() + " Dest= " + this.writeFile.getCanonicalPath());
                        }
                        catch (IOException ex) {
                            logger.fine("File Copy failed.");
                        }
                    }
                }
                Object var8_7 = null;
                if (null != handler) {
                    handler.dispose();
                }
                if (null == parser) break block11;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (null != handler) {
                    handler.dispose();
                }
                if (null != parser) {
                    parser.dispose();
                }
                if (null != this.outputStream) {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                throw throwable;
            }
            parser.dispose();
        }
        if (null != this.outputStream) {
            this.outputStream.close();
            this.outputStream = null;
        }
        return true;
    }

    public boolean preParse(FormNode node) {
        if (this.preParseComplete) {
            return true;
        }
        if (!(node instanceof XFDL)) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ReferenceRootInvalid.toStringAsRequest(), (Object)"FormNodeP.UFL_FORM"));
        }
        this.preParseComplete = true;
        return true;
    }
}

