/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.action;

import com.ibm.form.api.internal.action.IParse;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class Action
implements IParse {
    public static final int OPTION_NAME_INDEX = 2;
    static final int OPTION_NAME_LENGTH = 3;
    private int referenceType;
    private String relativeReference;
    private String arrayIndicesString;
    private String[] prefixNameParts;
    private String[] uriNameParts;
    private int relativeIndex;
    private int originalNumberParts;
    private FormNode namespaceNode;
    private boolean namespaceResolutionDone = false;
    boolean preParseComplete = false;
    String[] parseMapEntry = new String[0];

    public Action() {
        this.referenceType = 0;
        this.relativeReference = "";
        this.arrayIndicesString = "";
        this.prefixNameParts = new String[0];
        this.uriNameParts = new String[0];
        this.relativeIndex = 0;
        this.originalNumberParts = 0;
        this.namespaceNode = null;
    }

    public Action(String reference, int referenceType, FormNode namespaceNode) {
        this.initialize(reference, referenceType, namespaceNode);
    }

    public String toString() {
        return this.relativeReference;
    }

    public String getArrayIndicesString() {
        return this.arrayIndicesString;
    }

    public FormNode getNamespaceNode() {
        return this.namespaceNode;
    }

    public int getNumberOfRelativeReferenceElements() {
        return this.originalNumberParts;
    }

    public String[] getParseMapEntry() {
        return this.parseMapEntry;
    }

    public String[] getPrefixNames() {
        return this.prefixNameParts;
    }

    public int getReferenceType() {
        return this.referenceType;
    }

    public int getRelativeIndex() {
        return this.relativeIndex;
    }

    public String getRelativeReference() {
        return this.relativeReference;
    }

    public String[] getURINames() {
        return this.uriNameParts;
    }

    public boolean hasArrayIndices() {
        return null != this.arrayIndicesString;
    }

    public boolean preParse(FormNode node) {
        if (this.preParseComplete) {
            return true;
        }
        node.validateReference(this);
        String[] nodeReference = node.getReference(null).split("\\.");
        block0 : switch (this.getReferenceType()) {
            case 393216: {
                break;
            }
            case 131072: {
                if (1 == this.relativeIndex) {
                    if (this.relativeIndex > nodeReference.length) {
                        throw new IllegalArgumentException();
                    }
                    this.prependPrefixNameParts(nodeReference, this.relativeIndex);
                    break;
                }
                if (0 == this.relativeIndex) break;
                throw new IllegalStateException();
            }
            case 65536: {
                if (0 == this.relativeIndex) break;
                if (1 == this.relativeIndex || 2 == this.relativeIndex) {
                    if (this.relativeIndex > nodeReference.length) {
                        throw new IllegalArgumentException();
                    }
                    this.prependPrefixNameParts(nodeReference, this.relativeIndex);
                    break;
                }
                throw new IllegalStateException();
            }
            case 589824: {
                switch (this.relativeIndex) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        if (this.relativeIndex > nodeReference.length) {
                            throw new IllegalArgumentException();
                        }
                        this.prependPrefixNameParts(nodeReference, this.relativeIndex);
                        break block0;
                    }
                }
                String reference = node.getReference(null);
                int index = reference.indexOf("[");
                if (-1 != index) {
                    int length = this.prefixNameParts.length - 3;
                    String[] relativeIndices = new String[length];
                    System.arraycopy(this.prefixNameParts, 3, relativeIndices, 0, length);
                    System.arraycopy(nodeReference, 0, this.prefixNameParts, 0, 3);
                    String indices = reference.substring(index);
                    this.addArrayElements(indices, 3);
                    index = this.prefixNameParts[2].indexOf("[");
                    if (-1 != index) {
                        this.prefixNameParts[2] = this.prefixNameParts[2].substring(0, index);
                    }
                    for (int i = 3; i < this.prefixNameParts.length; ++i) {
                        if (!"ae".equals(this.prefixNameParts[i])) continue;
                        this.prefixNameParts[i] = "0";
                    }
                    this.relativeIndex = this.prefixNameParts.length;
                    String[] newArray = new String[this.relativeIndex + length];
                    System.arraycopy(this.prefixNameParts, 0, newArray, 0, this.relativeIndex);
                    System.arraycopy(relativeIndices, 0, newArray, this.relativeIndex, length);
                    this.prefixNameParts = newArray;
                    break;
                }
                if (this.relativeIndex > nodeReference.length) {
                    throw new IllegalArgumentException();
                }
                this.prependPrefixNameParts(nodeReference, this.relativeIndex);
                break;
            }
            default: {
                throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)this.prefixNameParts.toString()));
            }
        }
        this.parseMapEntry = new String[this.prefixNameParts.length];
        System.arraycopy(this.prefixNameParts, 0, this.parseMapEntry, 0, this.parseMapEntry.length);
        this.preParseComplete = true;
        return true;
    }

    public void resolveNamespace(FormNode node) {
        int baseIndex;
        if (this.namespaceResolutionDone) {
            return;
        }
        if (!this.preParseComplete) {
            this.preParse(node);
        }
        if (null == this.namespaceNode) {
            this.namespaceNode = node;
        }
        int length = this.prefixNameParts.length;
        this.uriNameParts = new String[length];
        System.arraycopy(this.prefixNameParts, 0, this.uriNameParts, 0, length);
        if (this.hasArrayIndices()) {
            baseIndex = 2;
        } else {
            int n = baseIndex = this.referenceType == 65536 ? 2 : 3;
        }
        if (length >= baseIndex) {
            for (int i = baseIndex; i < length; ++i) {
                this.uriNameParts[i] = this.resolveNamespace(this.prefixNameParts[i]);
            }
        }
        this.namespaceResolutionDone = true;
    }

    int arrayIndex(String name) {
        int result = -1;
        boolean isChar = false;
        char[] ch = name.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (Character.isDigit(ch[i])) continue;
            isChar = true;
            break;
        }
        if (!isChar) {
            try {
                result = new Integer(name);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return result;
    }

    FormNode[] getNodes(FormNode node, boolean autoCreate) {
        FormNode rootNode = node.getStartNode(this);
        return rootNode.getNodes(this, this.getRelativeIndex(), autoCreate);
    }

    void initialize(String reference, int referenceType, FormNode namespaceNode) {
        if (null == reference) {
            throw new IllegalArgumentException(Messages.ParameterNull.toStringAsRequest());
        }
        this.setRelativeReference(reference, referenceType);
        switch (this.referenceType) {
            case 65536: 
            case 131072: 
            case 393216: 
            case 589824: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.ReferenceTypeNotSupported.toStringAsRequest());
            }
        }
        this.namespaceNode = namespaceNode;
    }

    void prependPrefixNameParts(String[] name, int number) {
        System.arraycopy(name, 0, this.prefixNameParts, 0, number);
    }

    void resetURINameParts(String[] name) {
        this.uriNameParts = new String[name.length];
        System.arraycopy(name, 0, this.uriNameParts, 0, name.length);
    }

    /*
     * WARNING - void declaration
     */
    String resolveNamespace(String prefixedName) {
        void var3_4;
        String[] name = prefixedName.split(":");
        switch (name.length) {
            case 1: {
                String result;
                int asInt = this.arrayIndex(name[0]);
                if (-1 == asInt) {
                    if ("*".equals(name[0]) || "**".equals(name[0])) {
                        result = name[0];
                        break;
                    }
                    result = this.namespaceNode.getXFDLNamespaceURI() + "#" + name[0];
                    break;
                }
                result = name[0];
                break;
            }
            case 2: {
                String result;
                if ("null".equals(name[0])) {
                    result = "#" + name[1];
                    break;
                }
                result = this.namespaceNode.getNamespaceURIFromPrefix(name[0]) + "#" + name[1];
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ParameterInvalid.toStringAsRequest(), (Object)name.toString()));
            }
        }
        return var3_4;
    }

    void setParseMapEntry(String[] prefixNameParts) {
        this.parseMapEntry = prefixNameParts;
    }

    private void addArrayElements(String arrayPart, int numberOfParts) {
        int start = arrayPart.indexOf(91);
        if (-1 == start) {
            if (numberOfParts != this.prefixNameParts.length) {
                String[] newArray = new String[numberOfParts];
                System.arraycopy(this.prefixNameParts, 0, newArray, 0, numberOfParts);
                this.prefixNameParts = newArray;
            }
            return;
        }
        int end = arrayPart.indexOf(93, start);
        if (-1 == end) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidSubOptionFormat.toStringAsRequest(), (Object)this.relativeReference));
        }
        int start2 = arrayPart.indexOf(91, start + 1);
        if (-1 != start2 && start2 < end) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidSubOptionFormat.toStringAsRequest(), (Object)this.relativeReference));
        }
        if (1 == end - start) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidSubOptionFormat.toStringAsRequest(), (Object)this.relativeReference));
        }
        int length = this.prefixNameParts.length;
        if (numberOfParts == length) {
            String[] newArray = new String[length + 4];
            System.arraycopy(this.prefixNameParts, 0, newArray, 0, length);
            this.prefixNameParts = newArray;
        }
        this.prefixNameParts[numberOfParts++] = arrayPart.substring(start + 1, end);
        this.addArrayElements(arrayPart.substring(end + 1), numberOfParts);
    }

    private void setRelativeReference(String reference, int referenceType) {
        this.relativeReference = reference;
        this.referenceType = referenceType & 0xFFFF0000;
        int firstIndex = reference.indexOf("[");
        this.prefixNameParts = -1 == firstIndex ? this.relativeReference.split("\\.") : (0 == firstIndex ? new String[0] : this.relativeReference.substring(0, firstIndex).split("\\."));
        for (int i = 0; i < this.prefixNameParts.length; ++i) {
            int index = this.prefixNameParts[i].indexOf("**");
            if (-1 != index) {
                this.prefixNameParts[i] = "**";
                continue;
            }
            index = this.prefixNameParts[i].indexOf("*");
            if (-1 == index) continue;
            this.prefixNameParts[i] = "*";
        }
        this.arrayIndicesString = -1 == firstIndex ? null : this.relativeReference.substring(firstIndex);
        this.originalNumberParts = this.prefixNameParts.length;
        block0 : switch (this.originalNumberParts) {
            case 3: {
                this.relativeIndex = 0;
                break;
            }
            case 2: {
                if (65536 == this.referenceType || 589824 == this.referenceType) {
                    String[] newArray = new String[this.originalNumberParts + 1];
                    System.arraycopy(this.prefixNameParts, 0, newArray, 1, this.originalNumberParts);
                    this.prefixNameParts = newArray;
                    this.relativeIndex = 1;
                    break;
                }
                this.relativeIndex = 0;
                break;
            }
            case 1: {
                switch (this.referenceType) {
                    case 393216: {
                        this.relativeIndex = 0;
                        break block0;
                    }
                    case 131072: {
                        String[] newArray = new String[this.originalNumberParts + 1];
                        System.arraycopy(this.prefixNameParts, 0, newArray, 1, this.originalNumberParts);
                        this.prefixNameParts = newArray;
                        this.relativeIndex = 1;
                        break block0;
                    }
                    case 65536: 
                    case 589824: {
                        String[] newArray = new String[this.originalNumberParts + 2];
                        System.arraycopy(this.prefixNameParts, 0, newArray, 2, this.originalNumberParts);
                        this.prefixNameParts = newArray;
                        this.relativeIndex = 2;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)this.relativeReference));
            }
            case 0: {
                if (0 == firstIndex) {
                    this.prefixNameParts = new String[3];
                    this.prefixNameParts[2] = "";
                    this.relativeIndex = 3;
                    break;
                }
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)this.relativeReference));
            }
            default: {
                throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.InvalidReference.toStringAsRequest(), (Object)this.relativeReference));
            }
        }
        if (-1 != firstIndex) {
            this.verifyArrayElements();
            this.addArrayElements(this.arrayIndicesString, this.prefixNameParts.length);
        }
    }

    private void verifyArrayElements() {
        if (-1 != this.arrayIndicesString.indexOf(".")) {
            throw new IllegalArgumentException(this.relativeReference);
        }
    }

    public abstract /* synthetic */ boolean postParse(FormNode var1, boolean var2) throws IOException, ParserConfigurationException, SAXException;
}

