/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api;

import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.parser.sax.FormHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParser;
import com.ibm.form.api.internal.utilities.LocalFile;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Document {
    private LocalFile file = null;
    private XFDLParser parser;
    private FormNode form;
    private int flags;

    public Document(String filePath, int flags) throws ParserConfigurationException, SAXException, IOException {
        if (null == filePath) {
            throw new IllegalArgumentException(Messages.OutputSourceNull.toStringAsRequest());
        }
        this.initialize(filePath, flags);
    }

    public Document(InputStream inputStream, int flags) throws ParserConfigurationException, SAXException, IOException {
        if (null == inputStream) {
            throw new IllegalArgumentException(Messages.OutputSourceNull.toStringAsRequest());
        }
        boolean done = false;
        try {
            this.file = new LocalFile(inputStream);
            this.initialize(this.file.getCanonicalPath(), flags);
            done = true;
            Object var6_4 = null;
            if (!done && null != this.file) {
                this.file.dispose();
                this.file = null;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!done && null != this.file) {
                this.file.dispose();
                this.file = null;
            }
            throw throwable;
        }
    }

    public Document(Reader reader, int flags) throws ParserConfigurationException, SAXException, IOException {
        if (null == reader) {
            throw new IllegalArgumentException(Messages.OutputSourceNull.toStringAsRequest());
        }
        boolean done = false;
        try {
            this.file = new LocalFile(reader);
            this.initialize(this.file.getCanonicalPath(), flags);
            done = true;
            Object var6_4 = null;
            if (!done && null != this.file) {
                this.file.dispose();
                this.file = null;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!done && null != this.file) {
                this.file.dispose();
                this.file = null;
            }
            throw throwable;
        }
    }

    public void dispose() throws IOException {
        if (null != this.parser) {
            this.parser.dispose();
            this.parser = null;
        }
        if (null != this.file) {
            this.file.dispose();
            this.file = null;
        }
        if (null != this.form) {
            this.form.dispose();
            this.form = null;
        }
    }

    public String getEncoding() {
        return this.parser.getParserData().getEncoding();
    }

    public FormNode getForm() {
        return this.form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List actions) throws ParserConfigurationException, SAXException, IOException {
        block8: {
            if (0 == this.parser.getParserData().getNumberOfPasses()) {
                if (null != this.form) {
                    throw new IllegalStateException();
                }
                FormHandler handler = new FormHandler(this.parser);
                try {
                    try {
                        this.parser.parse(handler, handler.getForm(), actions);
                        this.parser.process(handler.getForm(), actions, false);
                        break block8;
                    }
                    finally {
                        this.form = handler.getForm();
                    }
                }
                finally {
                    handler.dispose();
                }
            }
            this.form.process(actions);
        }
    }

    private void initialize(String filePath, int flags) throws ParserConfigurationException, SAXException, IOException {
        int speedFlags = 25336840;
        this.flags = flags;
        if (142777352 != this.flags && speedFlags != this.flags) {
            throw new IllegalArgumentException(LocalizedStringFormat.bind(Messages.ParameterInvalid.toStringAsRequest(), (Object)new Integer(flags).toString()));
        }
        this.parser = new XFDLParser(filePath);
    }
}

