/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.security.AbstractLoginModule;
import is.hugvit.bird.jaas.security.BirdRolePrincipal;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.bird.jaas.security.client.BirdAuthentication;
import is.hugvit.bird.jaas.security.client.BirdAuthenticationService;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.ws.BindingProvider;

public class PlainLoginModule
extends AbstractLoginModule
implements LoginModule {
    public PlainLoginModule() {
        this.debug(this.getClass().getName() + " loaded");
    }

    @Override
    public boolean commit() throws LoginException {
        this.debug(this.getClass().getName() + " Commit");
        if (this.currentUser == null) {
            throw new LoginException("No user to commit");
        }
        try {
            this.subject.getPrincipals().add(this.currentUser);
            Iterator it = this.currentUser.getRoles().iterator();
            while (it.hasNext()) {
                BirdRolePrincipal birdRole = new BirdRolePrincipal((String)it.next());
                if (this.subject.getPrincipals().contains(birdRole)) continue;
                this.subject.getPrincipals().add(birdRole);
                this.debug("Adding role: " + birdRole.getName());
            }
            this.debug(this.getClass().getName() + " Commit finished");
            return true;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean abort() throws LoginException {
        return super.abort();
    }

    @Override
    public void initialize(Subject sub, CallbackHandler handler, Map state, Map opts) {
        super.initialize(sub, handler, state, opts);
    }

    @Override
    public boolean login() throws LoginException {
        this.debug(this.getClass().getName() + " login");
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        if (this.birdLoginServiceUrl == null || "".equals(this.birdLoginServiceUrl)) {
            throw new LoginException("Cannot proceed, Bird login Service is not defined.");
        }
        try {
            this.callbackHandler.handle(callbacks);
            String name = ((NameCallback)callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            this.debug("user: " + name + " pass: " + password);
            URL url = PlainLoginModule.class.getResource("/META-INF/wsdl/Authentication.wsdl");
            BirdAuthenticationService client = new BirdAuthenticationService(url);
            BirdAuthentication proxy = client.getBirdAuthenticationPort();
            this.debug("Launching endpoint authentication");
            ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.birdLoginServiceUrl);
            this.debug("WS Login Provider set to: " + this.birdLoginServiceUrl);
            is.hugvit.bird.jaas.security.client.BirdUserPrincipal birdPrincipal = proxy.authenticate(name, password);
            if (birdPrincipal == null) {
                this.debug("Authentication failed. User: " + name);
                return false;
            }
            if (birdPrincipal.getRoles() == null || birdPrincipal.getRoles().size() == 0) {
                throw new LoginException("Authentication failed: No roles are assigned to user");
            }
            this.currentUser = new BirdUserPrincipal();
            this.currentUser.setName(birdPrincipal.getName());
            this.currentUser.setRoles(birdPrincipal.getRoles());
            this.currentUser.setUserId(birdPrincipal.getUserId());
            this.currentUser.setFullName(birdPrincipal.getFullName());
            this.currentUser.setEmail(birdPrincipal.getEmail());
            this.debug("User has been successfully set - Login Succeded");
            return true;
        }
        catch (IOException ex) {
            throw new LoginException(ex.getMessage());
        }
        catch (UnsupportedCallbackException ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.debug("Logout");
        return super.logout();
    }
}

