/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.security.AbstractLoginModule;
import is.hugvit.bird.jaas.security.BirdRolePrincipal;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import java.io.IOException;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class JdbcLoginModule
extends AbstractLoginModule
implements LoginModule {
    private static final int iterations = 5555;
    private static final int keyLength = 512;
    private static final String pepper = "C0ldC0ff33#ndr01dHeineken";
    private String dsDriver;
    private String dsConnection;
    private String dsUsername;
    private String dsPassword;

    public JdbcLoginModule() {
        this.debug(this.getClass().getName() + " loaded");
    }

    @Override
    public void initialize(Subject sub, CallbackHandler handler, Map state, Map opts) {
        super.initialize(sub, handler, state, opts);
        Object driver = this.options.get("driver");
        Object connection = this.options.get("conn");
        Object username = this.options.get("username");
        Object password = this.options.get("password");
        if (driver != null) {
            this.dsDriver = (String)driver;
        }
        if (connection != null) {
            this.dsConnection = (String)connection;
        }
        if (username != null) {
            this.dsUsername = (String)username;
        }
        if (password != null) {
            this.dsPassword = (String)password;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        this.debug(this.getClass().getName() + " Commit");
        if (this.currentUser == null) {
            throw new LoginException("No user to commit");
        }
        try {
            this.subject.getPrincipals().add(this.currentUser);
            Iterator it = this.currentUser.getRoles().iterator();
            while (it.hasNext()) {
                BirdRolePrincipal birdRole = new BirdRolePrincipal((String)it.next());
                if (this.subject.getPrincipals().contains(birdRole)) continue;
                this.subject.getPrincipals().add(birdRole);
                this.debug("Adding role: " + birdRole.getName());
            }
            try {
                this.createSuccessLogEntry();
            }
            catch (Exception ex) {
                this.debug("Error creating log entry: " + ex.getMessage());
            }
            this.debug(this.getClass().getName() + " Commit finished");
            return true;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.debug(this.getClass().getName() + " login");
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        this.validateConnectionOptions();
        try {
            this.callbackHandler.handle(callbacks);
            String name = ((NameCallback)callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            this.debug("user: " + name + " pass: " + password);
            this.debug("Launching jdbc authentication");
            this.currentUser = this.jdbcAuthenticate(name, password);
            if (this.currentUser == null) {
                this.debug("Authentication failed. User: " + name);
                throw new LoginException("Authentication failed");
            }
            if (this.currentUser.getRoles() == null || this.currentUser.getRoles().size() == 0) {
                throw new LoginException("Authentication failed: No roles are assigned to user");
            }
            this.debug("User has been set - Login Succeded");
            return true;
        }
        catch (IOException ex) {
            throw new LoginException(ex.getMessage());
        }
        catch (UnsupportedCallbackException ex) {
            throw new LoginException(ex.getMessage());
        }
        catch (LoginException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        return super.logout();
    }

    private BirdUserPrincipal jdbcAuthenticate(String username, String password) throws LoginException {
        BirdUserPrincipal principal = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        this.debug("Starting SQL Query");
        try {
            String dbPassword;
            String TBL_USERS = "ss_users";
            String TBL_USERROLES = "ss_userroles";
            String TBL_ROLEMAP = "ss_userrolemap";
            String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.lang FROM ss_users u WHERE u.username = ? AND u.is_deleted = 0 AND u.is_verified = 1";
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (rs.next() && (dbPassword = rs.getString("password")) != null) {
                if (dbPassword.equals(JdbcLoginModule.hashPassword(password))) {
                    this.debug("Found user match for: " + username);
                    principal = new BirdUserPrincipal();
                    principal.setName(rs.getString("username"));
                    principal.setFullName(rs.getString("fullname"));
                    principal.setUserId(rs.getString("user_id"));
                    principal.setEmail(rs.getString("email"));
                    principal.setLocale(rs.getString("lang"));
                } else if (dbPassword.equals(JdbcLoginModule.hashPasswordLegacy(password))) {
                    this.debug("Matches the legacy hash, authenticate and update.");
                    this.debug("Found user match for: " + username);
                    principal = new BirdUserPrincipal();
                    principal.setName(rs.getString("username"));
                    principal.setFullName(rs.getString("fullname"));
                    principal.setUserId(rs.getString("user_id"));
                    principal.setEmail(rs.getString("email"));
                    principal.setLocale(rs.getString("lang"));
                    this.updatePassword(principal.getUserId(), JdbcLoginModule.hashPassword(password));
                } else {
                    try {
                        String authUserId = rs.getString("user_id");
                        this.createLogEntry(authUserId, "FAILED_LOGIN");
                    }
                    catch (Exception ex) {
                        this.debug("Error creating log entry: " + ex.getMessage());
                    }
                }
            }
            stmt.close();
            rs.close();
            if (principal != null) {
                sql = "SELECT r.rolename FROM ss_userroles r INNER JOIN ss_userrolemap m ON r.role_id = m.role_id WHERE m.user_id = ? AND r.is_deleted = 0";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, principal.getUserId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    principal.getRoles().add(rs.getString("rolename"));
                }
                rs.close();
            }
            if (principal != null) {
                this.debug("Principal successfully set for: " + principal.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new LoginException(ex.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                throw new LoginException(ex.getMessage());
            }
        }
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePassword(String userId, String hashedPassword) throws Exception {
        Connection con = null;
        Statement stmt = null;
        try {
            String TBL_USERS = "ss_users";
            String sql = "UPDATE ss_users SET password = ? WHERE user_id = ?";
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, hashedPassword);
            stmt.setString(2, userId);
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLogEntry(String userId, String action) throws Exception {
        Connection con = null;
        Statement stmt = null;
        try {
            String TBL_LOG = "ss_history";
            String sql = "INSERT INTO ss_history (document_id, user_id, stamp, action, datatype) VALUES (?,?,?,?,?)";
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setString(2, userId);
            stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
            stmt.setString(4, action);
            stmt.setString(5, "USER");
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSuccessLogEntry() throws Exception {
        Connection con = null;
        Statement stmt = null;
        try {
            String TBL_LOG = "ss_history";
            String sql = "INSERT INTO ss_history (document_id, user_id, stamp, action, datatype) VALUES (?,?,?,?,?)";
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, this.currentUser.getUserId());
            stmt.setString(2, this.currentUser.getUserId());
            stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
            stmt.setString(4, "LOGIN");
            stmt.setString(5, "USER");
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    private Connection getConnection() throws Exception {
        Class.forName(this.dsDriver).newInstance();
        return DriverManager.getConnection(this.dsConnection, this.dsUsername, this.dsPassword);
    }

    private void validateConnectionOptions() throws LoginException {
        String[] fields;
        for (String s : fields = new String[]{this.dsConnection, this.dsDriver, this.dsUsername, this.dsPassword}) {
            if (s != null) continue;
            throw new LoginException("JDBC options are not set, the following options must be set: [driver,conn,username,password]");
        }
    }

    private static String hashPassword(String password) throws Exception {
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), pepper.getBytes(), 5555, 512);
        SecretKey key = skf.generateSecret(spec);
        byte[] res = key.getEncoded();
        return JdbcLoginModule.encodeHexString(res);
    }

    private static final String hashPasswordLegacy(String password) throws Exception {
        StringBuffer encoded = new StringBuffer();
        if (password != null) {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(password.getBytes("UTF-8"));
            byte[] digest = md5.digest();
            for (int i = 0; i < digest.length; ++i) {
                int b = digest[i] & 0xFF;
                if (b < 16) {
                    encoded.append("0");
                }
                encoded.append(Integer.toHexString(b));
            }
        }
        return encoded.toString();
    }

    private static String encodeHexString(byte[] byteArray) {
        StringBuffer hexStringBuffer = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            hexStringBuffer.append(JdbcLoginModule.byteToHex(byteArray[i]));
        }
        return hexStringBuffer.toString();
    }

    private static String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }
}

