/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.callback.CertificateSubjectCallback;
import is.hugvit.bird.jaas.security.AbstractLoginModule;
import is.hugvit.bird.jaas.security.BirdRolePrincipal;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class CertificateSubjectLoginModule
extends AbstractLoginModule
implements LoginModule {
    @Override
    public void initialize(Subject sub, CallbackHandler handler, Map sharedState, Map opts) {
        super.initialize(sub, handler, sharedState, opts);
    }

    @Override
    public boolean commit() throws LoginException {
        this.debug("Commit");
        if (this.currentUser == null) {
            throw new LoginException("No user to commit");
        }
        try {
            this.subject.getPrincipals().add(this.currentUser);
            this.subject.getPrincipals().add(new BirdRolePrincipal("citizen"));
            this.subject.getPrincipals().add(new BirdRolePrincipal("administrator"));
            Iterator it = this.currentUser.getRoles().iterator();
            while (it.hasNext()) {
                BirdRolePrincipal birdRole = new BirdRolePrincipal((String)it.next());
                if (this.subject.getPrincipals().contains(birdRole)) continue;
                this.subject.getPrincipals().add(birdRole);
                this.debug("Adding role: " + birdRole.getName());
            }
            this.debug("Commit finished for user: " + this.currentUser.getName());
            return true;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean login() throws LoginException {
        CertificateSubjectCallback cc = new CertificateSubjectCallback("Name");
        Callback[] callbacks = new Callback[]{cc};
        this.debug("Certificate login");
        try {
            if (this.callbackHandler == null) {
                throw new LoginException("No Callback Handler available!");
            }
            this.callbackHandler.handle(callbacks);
            cc.populateValues();
            if (!cc.isValid()) {
                throw new LoginException("Data in not from a Certificate or the Certificate is not valid!");
            }
            if (cc.getUserName() == null || "".equals(cc.getUserName())) {
                throw new LoginException("Could not retrieve sufficient data from certificate");
            }
            this.debug("Got valid data from Certificate collection");
            this.debug("Certificate CN: " + cc.getCommonName());
            this.debug("Certifiacte Name: " + cc.getName());
            this.debug("Certificate Username: " + cc.getUserName());
            this.debug("Certificate Country: " + cc.getCountry());
            this.currentUser = new BirdUserPrincipal();
            this.currentUser.setName(cc.getUserName());
            this.currentUser.setRoles(Arrays.asList("citizen"));
            this.currentUser.setCertificateAuthentication(true);
            this.debug("User has been set");
            return true;
        }
        catch (IOException ex) {
            throw new LoginException(ex.getMessage());
        }
        catch (UnsupportedCallbackException ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        return super.logout();
    }

    @Override
    public boolean abort() throws LoginException {
        return super.abort();
    }
}

