/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.IBirdUserPrincipal;
import is.hugvit.bird.jaas.security.AbstractLoginModule;
import is.hugvit.bird.jaas.security.BirdRolePrincipal;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.bird.jaas.security.TrustAllSSLSocketFactory;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ActiveDirectoryLoginModule
extends AbstractLoginModule
implements LoginModule {
    private String directory;
    private String baseDn;
    private String searchBindDn;
    private String searchBindPassword;
    private String searchFilter;
    private String groupSearchFilter;
    private boolean attachCitizenRole = false;

    @Override
    public void initialize(Subject sub, CallbackHandler handler, Map state, Map opts) {
        String[] keys;
        super.initialize(sub, handler, state, opts);
        for (String key : keys = new String[]{"directory", "base-dn", "search-bind-dn", "search-bind-password", "search-filter", "group-search-filter", "add-citizenrole"}) {
            if (this.options.containsKey(key)) continue;
            throw new RuntimeException("Jaas config option: " + key + " is missing.  Cannot continue.");
        }
        this.directory = (String)this.options.get("directory");
        this.baseDn = (String)this.options.get("base-dn");
        this.searchBindDn = (String)this.options.get("search-bind-dn");
        this.searchBindPassword = (String)this.options.get("search-bind-password");
        this.searchFilter = (String)this.options.get("search-filter");
        this.groupSearchFilter = (String)this.options.get("group-search-filter");
        this.attachCitizenRole = this.options.get("add-citizenrole").equals("true");
    }

    @Override
    public boolean commit() throws LoginException {
        this.debug(this.getClass().getName() + " Commit");
        if (this.currentUser == null) {
            throw new LoginException("No user to commit");
        }
        try {
            this.subject.getPrincipals().add(this.currentUser);
            Iterator it = this.currentUser.getRoles().iterator();
            while (it.hasNext()) {
                BirdRolePrincipal birdRole = new BirdRolePrincipal((String)it.next());
                if (this.subject.getPrincipals().contains(birdRole)) continue;
                this.subject.getPrincipals().add(birdRole);
                this.debug("Adding role: " + birdRole.getName());
            }
            this.debug(this.getClass().getName() + " Commit finished");
            return true;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.debug(this.getClass().getName() + " login");
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        try {
            this.callbackHandler.handle(callbacks);
            String name = ((NameCallback)callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            this.debug("user: " + name + " pass: " + password);
            this.debug("Launching active directory authentication");
            this.currentUser = this.ldapAuthenticate(name, password);
            if (this.currentUser == null) {
                this.debug("Authentication failed. User: " + name);
                throw new LoginException("Authentication failed");
            }
            if (this.currentUser.getRoles() == null || this.currentUser.getRoles().size() == 0) {
                throw new LoginException("Authentication failed: No roles are assigned to user");
            }
            this.debug("User has been set - Login Succeded");
            return true;
        }
        catch (IOException ex) {
            throw new LoginException(ex.getMessage());
        }
        catch (UnsupportedCallbackException ex) {
            throw new LoginException(ex.getMessage());
        }
        catch (LoginException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    private IBirdUserPrincipal ldapAuthenticate(String username, String password) throws NamingException {
        BirdUserPrincipal principal = null;
        try (Context ctx = null;){
            String userFilter = String.format(this.searchFilter, username);
            ctx = this.createContext();
            ctx.setRequestControls(null);
            String commonName = "";
            String distinguishedName = "";
            this.debug("Base DN: " + this.baseDn);
            this.debug("Search filter: " + userFilter);
            NamingEnumeration<SearchResult> namingEnum = ctx.search(this.baseDn, userFilter, this.getSimpleSearchControls());
            if (namingEnum.hasMore()) {
                SearchResult result = namingEnum.next();
                Attributes attrs = result.getAttributes();
                commonName = attrs.get("cn").get().toString();
                distinguishedName = attrs.get("distinguishedName").get().toString();
                this.debug("Found user in directory, trying authentication for: " + distinguishedName);
                if (this.authenticateUser(distinguishedName, password)) {
                    this.debug("User " + commonName + " was authenticated");
                    principal = new BirdUserPrincipal();
                    principal.setName(username);
                    principal.setFullName(commonName);
                    principal.setDirectoryAuthentication(true);
                    principal.setCertificateAuthentication(false);
                    Attribute email = attrs.get("mail");
                    if (email != null) {
                        String emailAddress = email.get().toString();
                        this.debug("Got mail entry: " + emailAddress);
                        principal.setEmail(emailAddress);
                    } else {
                        this.debug("No mail entry was provided");
                    }
                }
            }
            namingEnum.close();
            if (principal != null) {
                String groupSearch = String.format(this.groupSearchFilter, distinguishedName);
                namingEnum = ctx.search(this.baseDn, groupSearch, this.getSimpleSearchControls());
                while (namingEnum.hasMore()) {
                    SearchResult result = namingEnum.next();
                    Attributes attrs = result.getAttributes();
                    String roleName = attrs.get("cn").get().toString();
                    if (roleName == null || roleName.equals("")) continue;
                    this.debug("[" + commonName + "] Adding user role: " + roleName);
                    principal.getRoles().add(new String(roleName));
                }
                namingEnum.close();
                if (this.attachCitizenRole) {
                    principal.getRoles().add("citizen");
                }
            }
            BirdUserPrincipal birdUserPrincipal = principal;
            return birdUserPrincipal;
        }
    }

    private boolean authenticateUser(String distinguishedName, String password) {
        try {
            LdapContext ctx = null;
            ctx = this.tryAuthentication(distinguishedName, password);
            ctx.close();
            return true;
        }
        catch (NamingException ex) {
            return false;
        }
    }

    private LdapContext tryAuthentication(String bindDN, String bindPassword) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.directory);
        if (this.directory.startsWith("ldaps")) {
            env.put("java.naming.ldap.factory.socket", TrustAllSSLSocketFactory.class.getCanonicalName());
            env.put("java.naming.security.protocol", "ssl");
        }
        env.put("java.naming.security.principal", bindDN);
        env.put("java.naming.security.credentials", bindPassword);
        env.put("java.naming.security.authentication", "simple");
        InitialLdapContext context = new InitialLdapContext(env, null);
        return context;
    }

    private LdapContext createContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.directory);
        if (this.directory.startsWith("ldaps")) {
            env.put("java.naming.ldap.factory.socket", TrustAllSSLSocketFactory.class.getCanonicalName());
            env.put("java.naming.security.protocol", "ssl");
        }
        env.put("java.naming.security.principal", this.searchBindDn);
        env.put("java.naming.security.credentials", this.searchBindPassword);
        env.put("java.naming.security.authentication", "simple");
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        env.put("java.naming.referral", "follow");
        InitialLdapContext context = new InitialLdapContext(env, null);
        return context;
    }

    private SearchControls getSimpleSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setDerefLinkFlag(false);
        searchControls.setTimeLimit(30000);
        return searchControls;
    }
}

